definition module windows;

from StdInt import IF_INT_64_OR_32;

:: *WinState:==Int;

NULL:==0;

:: LP:==Int;
:: HANDLE:==Int;
:: UINT:==Int;

:: LPCTSTR:==LP;
:: HMODULE:==HANDLE;
:: HINSTANCE:==HANDLE;

GetModuleHandle :: !LPCTSTR !WinState -> (!HMODULE,!WinState);

:: HICON:==HANDLE;

IDI_APPLICATION:==32512;

LoadIcon :: !HINSTANCE !LPCTSTR !WinState -> (!HICON,!WinState);

IDC_ARROW:==32512;

:: HCURSOR:==HANDLE;

LoadCursor :: !HINSTANCE !LPCTSTR !WinState -> (!HCURSOR,!WinState);

SM_CXSMICON:==49;
SM_CYSMICON:==50;

GetSystemMetrics :: !Int !WinState -> (!Int,!WinState);

:: HGDIOBJ:==HANDLE;

WHITE_BRUSH:==0;

GetStockObject :: !Int !WinState -> (!HGDIOBJ,!WinState);

IMAGE_ICON:==1;

LR_DEFAULTCOLOR:==0x0000;

LoadImage :: !HINSTANCE !LPCTSTR !UINT !Int !Int !UINT !WinState -> (!HANDLE,!WinState);

:: ATOM:==Int;

:: WNDCLASSEX_S:=={#Int};

RegisterClassEx :: !WNDCLASSEX_S !WinState -> (!ATOM,!WinState);

CS_VREDRAW:==0x0001;
CS_HREDRAW:==0x0002;

string_constant_to_pointer :: !String -> Int;

:: HWND:==HANDLE;
:: LRESULT:==Int;
:: WPARAM:==Int;
:: LPARAM:==Int;

WS_OVERLAPPED :==0x00000000;
WS_CAPTION    :==0x00C00000; /* WS_BORDER | WS_DLGFRAME */
WS_SYSMENU    :==0x00080000;
WS_THICKFRAME :==0x00040000;
WS_MINIMIZEBOX:==0x00020000;
WS_MAXIMIZEBOX:==0x00010000;

WS_OVERLAPPEDWINDOW:==0x00CF0000;
	/* (WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_THICKFRAME | WS_MINIMIZEBOX | WS_MAXIMIZEBOX) */

:: LPCTSTR_S:==String;
:: DWORD:==Int;
:: LPVOID:==LP;
:: HMENU:==HANDLE;

CreateWindowEx :: !DWORD !LPCTSTR_S !LPCTSTR_S !DWORD !Int !Int !Int !Int !HWND !HMENU !HINSTANCE !LPVOID !WinState -> (!HWND,!WinState);
DefWindowProc :: !HWND !UINT !WPARAM !LPARAM !WinState -> (!LRESULT,!WinState);
DefWindowProc_NoWinState :: !HWND !UINT !WPARAM !LPARAM -> LRESULT;

::BOOL:==Int;

SW_SHOWNORMAL:==1;

ShowWindow :: !HWND !Int !WinState -> (!BOOL,!WinState);
UpdateWindow :: !HWND !WinState -> (!BOOL,!WinState);
GetTopWindow :: !HWND !WinState -> (!HWND,!WinState);

WM_CREATE:==0x0001;
WM_DESTROY:==0x0002;
WM_SIZE:==0x0005;
WM_PAINT:==0x000F;

::LPMSG_S:==String;

GetMessage :: !LPMSG_S !HWND !UINT !UINT !WinState -> (!BOOL,!WinState);
TranslateMessage :: !LPMSG_S !WinState -> (!BOOL,!WinState);
DispatchMessage :: !LPMSG_S !WinState -> (!LRESULT,!WinState);

:: LPRECT_S:==String;
:: LPRECT:==Int;

GetUpdateRect :: !HWND !LPRECT !BOOL !WinState -> (!BOOL,!WinState);

:: LPPAINTSTRUCT_S:==String;
:: HDC:==HANDLE;

BeginPaint :: !HWND !LPPAINTSTRUCT_S !WinState -> (!HDC,!WinState);
EndPaint :: !HWND !LPPAINTSTRUCT_S !WinState -> (!BOOL,!WinState);

::COLORREF:==Int;

SetPixelV :: !HDC !Int !Int !COLORREF !WinState -> (!BOOL,!WinState);
GetProcessHeap :: !WinState -> (!HANDLE,!WinState);

:: SIZE_T:==Int;

HeapAlloc :: !HANDLE !DWORD !SIZE_T !WinState -> (!LPVOID,!WinState);
HeapFree :: !HANDLE !DWORD !LPVOID !WinState -> (!BOOL,!WinState);

:: LONG_PTR:==Int;

GWL_USERDATA:== -21;

SetWindowLongPtr :: !HWND !Int !LONG_PTR !WinState -> (!LONG_PTR,!WinState);
GetWindowLongPtr :: !HWND !Int !WinState -> (!LONG_PTR,!WinState);

PostQuitMessage :: !Int !WinState -> WinState;

:: LPSECURITY_ATTRIBUTES:==Int;
:: LPTHREAD_START_ROUTINE:==Int;

CreateThread :: !LPSECURITY_ATTRIBUTES !SIZE_T !LPTHREAD_START_ROUTINE !LPVOID !DWORD !WinState -> (!HANDLE,!DWORD,!WinState);

INFINITE:==0xFFFFFFFF;

WaitForSingleObject :: !HANDLE !DWORD !WinState -> (!DWORD,!WinState);
CloseHandle :: !HANDLE !WinState -> WinState;

:: LPCRITICAL_SECTION:==LP;
CRITICAL_SECTION_SIZE_BYTES :== IF_INT_64_OR_32 40 24;

InitializeCriticalSection :: !LPCRITICAL_SECTION !WinState -> WinState;
EnterCriticalSection :: !LPCRITICAL_SECTION !WinState -> WinState;
LeaveCriticalSection :: !LPCRITICAL_SECTION !WinState -> WinState;
CreateEvent :: !LPSECURITY_ATTRIBUTES !Int !Int !LPCTSTR !WinState -> (!HANDLE,!WinState);
SetEvent :: !HANDLE !WinState -> (!BOOL,!WinState);
ResetEvent :: !HANDLE !WinState -> (!BOOL,!WinState);
GetLastError :: !WinState -> (!DWORD,!WinState);

KS_BI_RGB:==0;

DIB_RGB_COLORS:==0;
DIB_PAL_COLORS:==1;

SetDIBitsToDevice :: !HDC !Int !Int !DWORD !DWORD !Int !Int !UINT !UINT !{#Int} !{#Int} !UINT !WinState -> (!Int,!WinState);
